
/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于存放测试用例工具函数
*
* 修改:
*   1. 类型 : 创建
*      作者 : 巫昭雯
*      时间 : 2021.04.26
*      内容 : 所有代码
************************************************************************************************/

/* exported get_webui_main_document */
/* exported get_webui_pop_leyer */
/* exported tc_tool_get_iframe_pop_layer */
/* exported tc_tool_get_iframe_window */
/* exported tc_tool_hardware_state */
/* exported tc_tool_judge_jump_page */
/* exported get_webui_sidebar_dom */
/* exported get_webui_pop_leyer_all */
/* exported tc_tool_get_random_idx */
/* exported tc_tool_close_all_layer */
/* exported tc_tool_go_home */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取当前webui主体document
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Object> } webui ifrem id === iframe_content_subpage 的document
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-04-26
 *       内容 : 所有代码
************************************************************************************************/
function get_webui_main_document() {
    var obj_ifrem = document.getElementById("tifrem_led");
    var obj_ifrem_sub = obj_ifrem.contentDocument.getElementById("iframe_subpage");
    var obj_ifrem_sub_content = obj_ifrem_sub.contentDocument.getElementById("iframe_content_subpage");

    return obj_ifrem_sub_content.contentDocument;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取layer 弹窗
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Object> } layer层document
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-04-26
 *       内容 : 所有代码
************************************************************************************************/
function get_webui_pop_leyer() {
    var obj_ifrem = document.getElementById("tifrem_led");
    var obj_ifrem_sub = obj_ifrem.contentDocument.getElementById("iframe_subpage");
    var obj_pop = obj_ifrem_sub.contentDocument.getElementsByClassName("layui-layer-iframe");

    return obj_pop[0];
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取main层 HTMLIFrameElement
 * 备注:
 *    HTMLIFrameElement.contentWindow ：main window 对象
 *    HTMLIFrameElement.contentDocument ：main document 对象
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Object> } main层document
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 陈小荟
 *       时间 : 2021.05.08
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_get_main_htmliframe() {
    var obj_ifrem = document.getElementById("tifrem_led");
    var obj_ifrem_sub = obj_ifrem.contentDocument.getElementById("iframe_subpage");

    return obj_ifrem_sub;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取当前iframe window
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Object> } iframe层 window
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 陈小荟
 *       时间 : 2021.05.08
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_get_iframe_window() {
    var obj_ifrem = document.getElementById("tifrem_led");
    var obj_ifrem_sub = obj_ifrem.contentDocument.getElementById("iframe_subpage");
    var obj_ifrem_sub_content = obj_ifrem_sub.contentDocument.getElementById("iframe_content_subpage");

    return obj_ifrem_sub_content.contentWindow;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取iframe页面 内置弹窗 document
 * 参数:
 *    @param { Promise<Object> } iframe_document
 * 返回:
 *    @returns { Promise<Object> } iframe层document
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 陈小荟
 *       时间 : 2021.05.08
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_get_iframe_pop_layer(iframe_document) {
    if ("[object HTMLDocument]" !== Object.prototype.toString.call(iframe_document)) {
        var obj_ifrem = document.getElementById("tifrem_led");
        var obj_ifrem_sub = obj_ifrem.contentDocument.getElementById("iframe_subpage");

        iframe_document = obj_ifrem_sub.contentDocument.getElementById("iframe_content_subpage").contentDocument;
    }
    var obj_pop = iframe_document.getElementsByClassName("layui-layer-iframe")[0];

    if ("[object HTMLDivElement]" === Object.prototype.toString.call(obj_pop)) {
        obj_pop = obj_pop.children[1].children[0].contentDocument;
        return obj_pop;
    }

    return null;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取硬件连接状态
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Boolean> }
 *      true 硬件连接
 *      false 未连接硬件
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 陈小荟
 *       时间 : 2021.05.08
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_hardware_state() {
    return tc_tool_get_main_htmliframe().contentWindow.B_HARDWARE_STATE;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    顶层提示框 确定/取消 动作
 * 参数:
 *    @param { Promise<Boolean> } b_define true===确定 false===取消
 *    @param { Promise<Object> } obj_dialog 提示框document 可为空
 * 返回:
 *    @returns { Promise<Boolean> }
 *      true 设置成功
 *      false 参数有误
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 陈小荟
 *       时间 : 2021.05.14
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_dialog_define_cancel(b_define,obj_dialog) {
    if ("[object Boolean]" !== Object.prototype.toString.call(b_define)) {
        return false;
    }
    var ui_btn_index = b_define ? 0 : 1;
    var dialog = obj_dialog || tc_tool_get_main_htmliframe().contentDocument.getElementsByClassName("layui-layer-dialog");

    if (0 !== dialog.length) {
        dialog[0].children[3].children[ui_btn_index].click();
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    当前窗口加载完成后执行回调
 * 参数:
 *    @param { Promise<Object> } obj_document 当前窗口document
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    @returns { Promise<Boolean> }
 *      true 设置成功
 *      false 参数有误
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 陈小荟
 *       时间 : 2021.05.14
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_window_load_complete(obj_document,callback) {
    if ("[object HTMLDocument]" !== Object.prototype.toString.call(obj_document)) {
        return false;
    }
    if ("[object Function]" !== Object.prototype.toString.call(callback)) {
        return false;
    }
    if ("complete" === obj_document.readyState) {
        callback();
        return true;
    }
    obj_document.onreadystatechange = function () {
        if ("complete" === obj_document.readyState) {
            callback();
        }
        return true;
    };
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    跳转页面后执行回调
 * 参数:
 *    @param { Promise<String> } str_url url
 *    @param { Promise<Boolean> } b_define 提示框确认/取消
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    @returns { Promise<Boolean> }
 *      true 设置成功
 *      false 参数有误
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 陈小荟
 *       时间 : 2021.05.14
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_jump_page(str_url,b_define,callback) {
    if ("[object String]" !== Object.prototype.toString.call(str_url)) {
        return false;
    }
    if ("[object Boolean]" !== Object.prototype.toString.call(b_define)) {
        return false;
    }
    if ("[object Function]" !== Object.prototype.toString.call(callback)) {
        return false;
    }
    var main_document = tc_tool_get_main_htmliframe().contentWindow;

    main_document.STR_PAGE_PATH = str_url;
    main_document.update_lang_display();
    // 若有提示框关闭
    tc_tool_dialog_define_cancel(b_define);
    setTimeout(callback,1000);
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    1. 判断当前是否在所测试页面 否则跳转
 *    2. 执行回调
 * 参数:
 *    @param { Promise<String> } str_url url
 *    @param { Promise<String> } str_param 额外参数 "&is_save=false"
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    @returns { Promise<Boolean> }
 *      true 设置成功
 *      false 参数有误
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 陈小荟
 *       时间 : 2021.05.14
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_judge_jump_page(str_url,str_param,callback) {
    if ("[object String]" !== Object.prototype.toString.call(str_url)) {
        return false;
    }
    if ("[object Function]" !== Object.prototype.toString.call(callback)) {
        return false;
    }
    var main_document = tc_tool_get_main_htmliframe().contentWindow;

    main_document.layer.closeAll();
    if (str_url !== main_document.STR_PAGE_PATH.substr(0,str_url.length)) {
        tc_tool_jump_page(str_url + str_param,false,function () {
            var iframe_document = get_webui_main_document();

            tc_tool_window_load_complete(iframe_document,callback);
        });
        return true;
    }
    callback();
    return false;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取当前webui侧边栏 (main界面)
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Object> } obj_ifrem_sub 当前iframe层 ->main界面
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-26
 *       内容 : 所有代码
************************************************************************************************/

function get_webui_sidebar_dom() {
    var obj_ifrem = document.getElementById("tifrem_led");
    var obj_ifrem_sub = obj_ifrem.contentDocument.getElementById("iframe_subpage");

    return obj_ifrem_sub;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取layer 弹窗
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Object> } layer层document
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-10
 *       内容 : 所有代码
************************************************************************************************/
function get_webui_pop_leyer_all() {
    var obj_ifrem = document.getElementById("tifrem_led");
    var obj_ifrem_sub = obj_ifrem.contentDocument.getElementById("iframe_subpage");
    var obj_pop = obj_ifrem_sub.contentDocument.getElementsByClassName("layui-layer-iframe");

    return obj_pop;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取随机下标;
 * 参数:
 *    @param { Promise<Number> } len 数组的长度
 * 返回:
 *    @returns { Promise<Number> } 随机下标 || false
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-10
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_get_random_idx(len) {
    if ("number" !== typeof len) {
        return false;
    }

    if (len) {
        return Math.floor(Math.random() * len);
    }

    return false;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    关闭所有弹窗;
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_close_all_layer() {
    var obj_ifrem = document.getElementById("tifrem_led");
    var obj_ifrem_sub = obj_ifrem.contentDocument.getElementById("iframe_subpage");

    obj_ifrem_sub.contentWindow.layer.closeAll();
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    点击 '主页'
 * 参数:
 *    @param { Promise<String> } callback 延迟调用
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-21
 *       内容 : 所有代码
************************************************************************************************/
function tc_tool_go_home(callback) {
    document.getElementById("tifrem_led").contentDocument.getElementById("sys_btn_gohome").click();
    setTimeout(callback, 1000);
}
